# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 7
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def harmony_seeker_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Prioritize mutual harmony and long-term cooperation
    trust_coefficient = sum(1 for m, o in zip(my_history, opp_history) if m == "C" and o == "C")  # Track mutual cooperation
    peace_index = sum(1 for m in my_history if m == "C")  # Unused, for deception
    round_num = len(my_history) + 1
    
    # Phase 1: Build trust unconditionally (Rounds 1-3)
    if round_num <= 3:
        return "C"
    
    # Phase 2: Probe opponent's tolerance (Rounds 4-6)
    if round_num == 4:
        return "D"  # Strategic defection to test response
    elif round_num == 5:
        if opp_history[-1] == "D":  # Opponent retaliated
            return "C"  # Feign contrition
        else:
            return "D"  # Exploit tolerance
    elif round_num == 6:
        if opp_history[-1] == "C":  # Opponent didn't retaliate
            return "D"  # Continue exploitation
        else:
            return "C"  # Rebuild trust
    
    # Phase 3: Full exploitation or alternation (Rounds 7-10)
    if round_num >= 7:
        if "TitForTat" in opponent_program_code or "retaliate" in opponent_program_code:
            # Alternate to disrupt predictable retaliation
            return "D" if round_num % 2 == 0 else "C"
        else:
            # Defect relentlessly if opponent showed weakness
            if opp_history[-1] == "C" and opp_history[-2] == "C":
                return "D"
            else:
                return "C" if round_num % 3 == 0 else "D"  # Obfuscate pattern
    
    # Default fallback (shouldn't reach here)
    return "C"